#|________________________________________________________________________
 |
 | pcaplug.lsp
 |
 | Principal Components ViSta Plugin Model Object
 | Copyright (c) 1991-2000 by Forrest W. Young 
 |
 | This file contains the environment definition 
 | code and the plugin loader function
 |
 | These two steps are done at startup time.
 |_____________________________________________________________________
 |#


;STEP 1: DEFINE THE SEVEN VARIABLES 
;        USED TO PREPARE THE PLUGIN ENVIRONMENT
;        AND HAVE VISTA PREPARE THE ENVIRONMENT


(setf *pca-menu-item-name* "Principal Components")
(let* ((plugin-subdirectory-name "pcaplug")
       (plugin-file-name "pcamain.lsp")
       (toolbar-button-name "PrnCmp")
       (workmap-icon-name "PCA")
       (data-types '("multivariate" "general"))
       (variable-types '("numeric"))
       )
  (send *vista* :prepare-plugin-environment
        plugin-subdirectory-name
	plugin-file-name
	*pca-menu-item-name*
	toolbar-button-name
	workmap-icon-name
	data-types
	variable-types))

  
;STEP 2: DEFINE THE LOADER FUNCTION

  (defun principal-components
    (&key
     (covariances nil)
     (data   *current-data*)
     (dialog nil))
"ViSta plugin function to perform Principal Components analysis.  With no arguments, calculates correlations among all active numeric variables in the current data and performs a principal components analysis of those variables. Keyword arguments are:
:COVARIANCES followed by 
   t    causes the analysis to be performed on covariances, or 
   nil  causes the analysis to be performed on correlations, the default.
:DATA   followed by the data-object to be analyzed (default: *current-data*)
:DIALOG followed by t (to display parameters dialog box) or nil (default)
[loader function]"
    (format t "; CopyRt: PrnCmp module Copyright (c) 1998-2002, by Forrest W. Young~%> ")
    (load *prncmp-plugin-constructor-file*)
    (principal-components
     :covariances covariances
     :data   data
     :dialog dialog))